' BS1C Keyer - WD5GNR
' Features: Iambic, Dit/Dah memory, adjustable speed
'           Built in sidetone, preprogrammed memory playback
' Still to add: weight control, manual key input (w/sidetone)

' Register usage
' W0 - using Bit0 and Bit1
' W1 - Available
' W2 - Used
' W3 - Used
' W4 - Used
' W5 - B10 used; B11 available
' W6 - Used by GOSUB

Symbol  potport = 7
Symbol  potscale = 27
Symbol  pot_reading = b4
Symbol  length = w3
Symbol  loopctr = w4
Symbol  Ditswitch = pin2
symbol  Dahswitch = pin3
Symbol  ditmem = Bit0
Symbol  dahmem = Bit1
Symbol  keypin = 0    ' right now coded for active low
Symbol  spkrpin = 1
Symbol  mempin = pin6
Symbol  memcount = b5
Symbol  membyte = b2
Symbol  memmask = b10
Symbol  memvalue = b3

port=$73FF
b0=0  ' clear dit mem and dah mem in 1 stroke
loop:
pot potport,potscale,pot_reading
length=pot_reading*3/2+100
length=length*9
length=length/9 ' make even divisible by 9
' sense input
if mempin=0 then memplay
if Ditswitch=0 or ditmem=1 then dodit
ditcontinue:
' dodah... campfire girls sing their songs...
if Dahswitch=0 or dahmem=1 then dodah dahcontinue:
goto loop

dodit:
ditmem=0
gosub dit
goto ditcontinue

dodah:
dahmem=0
gosub dah
goto dahcontinue

Dit:
high keypin
for loopctr=1 to length step 9
toggle spkrpin
toggle spkrpin
dahmem=DahSwitch ^ 1 | dahmem
next loopctr
low keypin
for loopctr=1 to length step 9
low spkrpin ' equalize loop time
low spkrpin
dahmem=DahSwitch ^ 1 | dahmem
next loopctr
return

Dah:
high keypin
for loopctr=1 to length step 3
Toggle spkrpin
Toggle spkrpin
ditmem=DitSwitch ^ 1 | ditmem
next loopctr
low keypin
for loopctr=1 to length step 9
low spkrpin ' equalize
low spkrpin
ditmem=Ditswitch ^ 1 | ditmem
next loopctr
return

memplay:
read 0,memcount  ' count
membyte=1
memmask=128
memloop:
if memcount=0 then loop
read membyte,memvalue  
bit2=memvalue/memmask
if bit2=1 then dahspace
gosub dit
memnext:  ' go to next command
if ditmem=1 or dahmem=1 then loop
memmask=memmask/2
if memmask<>0 then memloop
gosub advance
goto memloop
dahspace:
memmask=memmask/2
if memmask<>0 then read1
gosub advance
if memcount=0 then loop
read1: ' get 2nd bit
read membyte,memvalue
bit2=memvalue/memmask
if bit2=1 then space
gosub dah
goto memnext
space:  ' do a character space
for loopctr=1 to length step 2 ' odd weight
low spkrpin ' equalize loop time
low spkrpin
low spkrpin
next loopctr
goto memnext

advance:
memmask=128
membyte=membyte+1
memcount=memcount-1
return

' Memory data
' CQ CQ CQ DE WD5GNR WD5GNR WD5GNR K
' This EEPROM line should be one line
' But it is too long for the page
eeprom 0,(24,$93,$A5,$F2,$74,$BE,$4E,$97,$C6,$F5,$71,$83,$A7,$34,$D5,$C6,$0E, $9C,$D3,$D5,$C6,$0E,$9C,$D3,$97)



