// FreqCtrView.cpp : implementation of the CFreqCtrView class
//

#include "stdafx.h"
#include "FreqCtr.h"

#include "FreqCtrDoc.h"
#include "LedDisplay.h"
#include "FreqCtrView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFreqCtrView

IMPLEMENT_DYNCREATE(CFreqCtrView, CFormView)

BEGIN_MESSAGE_MAP(CFreqCtrView, CFormView)
	//{{AFX_MSG_MAP(CFreqCtrView)
	ON_WM_TIMER()
	ON_COMMAND(IDM_COLOR, OnColor)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFreqCtrView construction/destruction

CFreqCtrView::CFreqCtrView()
	: CFormView(CFreqCtrView::IDD)
{
	//{{AFX_DATA_INIT(CFreqCtrView)
	m_freq = _T("");
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CFreqCtrView::~CFreqCtrView()
{
}

void CFreqCtrView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFreqCtrView)
	DDX_Control(pDX, IDC_MSCOMM1, m_comm);
	DDX_Text(pDX, IDC_FREQ, m_freq);
	//}}AFX_DATA_MAP
}

BOOL CFreqCtrView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CFreqCtrView printing

BOOL CFreqCtrView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CFreqCtrView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CFreqCtrView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CFreqCtrView::OnPrint(CDC* pDC, CPrintInfo*)
{
	// TODO: add code to print the controls
}

/////////////////////////////////////////////////////////////////////////////
// CFreqCtrView diagnostics

#ifdef _DEBUG
void CFreqCtrView::AssertValid() const
{
	CFormView::AssertValid();
}

void CFreqCtrView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CFreqCtrDoc* CFreqCtrView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFreqCtrDoc)));
	return (CFreqCtrDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFreqCtrView message handlers

BEGIN_EVENTSINK_MAP(CFreqCtrView, CFormView)
    //{{AFX_EVENTSINK_MAP(CFreqCtrView)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


void CFreqCtrView::OnInitialUpdate() 
{
	int port;
	CFormView::OnInitialUpdate();
	LED.SubclassDlgItem(IDC_FREQ,this);	
	port=((CFreqCtrApp *)AfxGetApp())->m_comport;
	m_comm.SetCommPort(port);
	m_comm.SetSettings("9600,N,8,1");
	m_comm.SetInputLen(0);
	m_comm.SetHandshaking(0); // no handshaking
	m_comm.SetRThreshold(0);  // no events
	m_comm.SetInBufferSize(4096);
	m_comm.SetPortOpen(TRUE);
	SetTimer(1,50,NULL);
	ResizeParentToFit(TRUE);
}



void CFreqCtrView::OnTimer(UINT nIDEvent) 
{
	if (m_comm.GetInBufferCount())
	{
	  VARIANT inputv;
	  char* input;
	  inputv=m_comm.GetInput();
	  int ct=m_comm.GetInBufferCount();
	  // got to convert BSTR to CString here
	  int len=m_comm.GetInBufferCount();
	  input=(char *)inputv.bstrVal;
	  
	  while (len--)
	  {
		  if (*input=='\x0d' || *input=='\x0a')
			{
			if (!value.IsEmpty())
				{
				unsigned v=strtoul(value,NULL,10);
				if (v!=0)
					{
					float f=1000000.0f/v;
					m_freq.Format("%d HZ",(int)f);
					}
				else
					m_freq="-0-";
				}
			  value.Empty();
			}
		else
		{
		  if (*input>='0' && *input<='9') value+=*input;
		}
	  input+=2; // skip hi byte of UNICODE characters
	  } 
	}
	UpdateData(FALSE);
	CFormView::OnTimer(nIDEvent);
}





void CFreqCtrView::OnColor() 
{
	CColorDialog dlg(LED.m_Color);
	if (dlg.DoModal()==IDOK)
		LED.m_Color=dlg.GetColor();
	LED.Invalidate(NULL);
}
