VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Stamp"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class module to interface PC to Stamp
' Williams - AWC
' http://www.al-williams.com/awce.htm
Option Explicit
Private comm As Object
Public RawResult    ' If you want the raw result
' Call this function first
Public Function Start(ByVal port As Integer) As Boolean
' Dynamic creation of an MSComm object -- how about that!
Set comm = CreateObject("MSCommLib.MSComm")
comm.CommPort = port
comm.Handshaking = comNone
comm.InputLen = 8
comm.InputMode = comInputModeBinary
comm.Settings = "9600,N,8,1"
comm.PortOpen = True
Start = comm.PortOpen
' Purge buffer
Do While comm.InBufferCount <> 0
  comm.Input
Loop
End Function
Public Function Shutdown() As Boolean
comm.PortOpen = False
Shutdown = True
End Function
Private Function StampResult() As String
Dim s
Dim timeo As Date
timeo = DateAdd("s", 20, Now)
Do While comm.InBufferCount <> 8
  If timeo < Now Then
    MsgBox "Timeout"
    Exit Function
  End If
Loop
s = comm.Input
If Left(s, 1) = Chr(0) Then
  MsgBox "Unexpected " & Hex(Asc(Left(s, 1)))
End If
  
RawResult = Right(s, 3)
StampResult = RawResult
End Function
' Common code for simple commands
Private Sub Cmd0(ByVal n, ByVal pin)
comm.Output = Chr(n) + Chr(0) + Chr(pin) + Chr(0) + Chr(0)
StampResult
End Sub
' Some binary helpers
Private Function lowbyte(ByVal n) As String
n = n And 255
lowbyte = Chr(n)
End Function
Private Function hibyte(ByVal n) As String
n = n / 256
n = n And 255
hibyte = Chr(n)
End Function
Private Function ReturnWord(ByVal s) As Long
ReturnWord = 256# * Asc(Mid(s, 3, 1)) + Asc(Mid(s, 2, 1))
End Function
Private Function Word(n) As String
Word = hibyte(n) & lowbyte(n)
End Function
Public Function Stamp_SetIO(mask, value) As Long
  comm.Output = Chr(1) + Word(mask) + Word(value)
  StampResult
  Stamp_SetIO = ReturnWord(RawResult)
End Function
Public Function Stamp_ReadInputs() As Long
Stamp_ReadInputs = Stamp_SetIO(0, 0)
End Function
Public Function Stamp_SetDIR(mask, value) As Long
  comm.Output = Chr(2) + Word(mask) + Word(value)
  StampResult
  SetDIR = ReturnWord(RawResult)
End Function
Public Function Stamp_ReadDIRS() As Long
ReadDIRS = SetDIR(0, 0)
End Function
Public Sub Stamp_Input(pin)
Cmd0 3, pin
End Sub
Public Sub Stamp_Output(pin)
Cmd0 4, pin
End Sub
Public Sub Stamp_Reverse(pin)
Cmd0 5, pin
End Sub
Public Sub Stamp_Low(pin)
Cmd0 6, pin
End Sub
Public Sub Stamp_High(pin)
Cmd0 7, pin
End Sub
Public Sub Stamp_Toggle(pin)
Cmd0 8, pin
End Sub
Public Function Stamp_Pulsin(pin, state)
comm.Output = Chr(9) + Chr(0) + Chr(pin) + Chr(0) + Chr(state)
StampResult
Stamp_Plusin = ReturnWord(RawResult)
End Function
Public Sub Stamp_Pulsout(pin, dur)
comm.Output = Chr(10) + Chr(0) + Chr(pin) + Word(dur)
StampResult
End Sub
Public Function Stamp_ShiftIn(dpin, cpin, mode, bits) As Long
End Function
Public Sub Stamp_ShiftOut(dpin, cpin, mode, bits, value)
End Sub
Public Function Stamp_Count(pin, period) As Long
comm.Output = Chr(13) + Chr(0) + Chr(pin) + Word(period)
StampResult
Stamp_Count = ReturnWord(RawResult)
End Function
Public Sub Stamp_PWM(pin, duty, dur)
comm.Output = Chr(15) + Chr(duty) + Chr(pin) + Word(dur)
StampResult
End Sub
Public Function Stamp_RCTime(pin, state) As Long
comm.Output = Chr(16) + Chr(0) + Chr(pin) + Chr(0) + Chr(state)
StampResult
Stamp_RCTime = ReturnWord(RawResult)
End Function
Public Sub Stamp_FreqOut(pin, dur, t1, t2)
Stamp_HiSet t1, t2
comm.Output = Chr(17) + Chr(0) + Chr(pin) + Word(dur)
StampResult
End Sub
Public Sub Stamp_DTMFOut(pin, ondur, offdur, tone)
comm.Output = Chr(18) + Chr(tone) + Chr(pin) + Chr(offdur) + Chr(ondur)
StampResult
End Sub
Public Sub Stamp_Write(ad, value)
comm.Output = Chr(19) + Chr(0) + Chr(ad) + Chr(0) + Chr(value)
StampResult
End Sub
Public Function Stamp_Read(ad) As Long
comm.Output = Chr(20) + Chr(0) + Chr(ad) + Word(0)
StampResult
Stamp_Read = Asc(Mid(RawResult, 3, 1))
End Function
Public Sub Stamp_HiSet(x, y)
comm.Output = Chr(30) + Word(x) + Word(y)
StampResult
End Sub
Public Function Stamp_Alive() As Boolean
comm.Output = Chr(31) + Word(0) + Word(0)
StampResult
Stamp_Alive = RawResult = Chr(0) & Chr(&HAA) & Chr(&H55)
End Function

