' Combo lock demo by Al Williams
' Shows how to use an RC network for generating
' a timeout
rctrig con 7 ' pin connected to capacitor
codelen con 5 ' length of combo
lockrelay con 0 ' turns on when unlocked
timeout var in7 
current var byte
switch var byte
test var byte 
output lockrelay
low lockrelay ' locked!

top:
current=-1 ' before 1st digit
' The code jumps here to advance to the next test digit
advance:
current=current+1 ' look at next digit
if current=codelen then unlock ' or, if done, we got em all
gosub resettimer ' reset timer on good key 
loop:
gosub readsw ' read switches
if switch=0 then testtime ' no switches? Look for timeout
' get current key to compare for
lookup current,[3,3,1,2,3],test 
if switch=test then advance ' right! Advance to next
debug "bad code",cr ' could make an obnoxious beep here
goto top ' Start over from beginning 
testtime:
if timeout=0 then loop ' still time, so keep looking
if current=0 then top ' don't complain if no entry
debug "timeout",cr
goto top 
unlock:
debug "unlocked",cr
high lockrelay
goto top ' go again for debugging purposes 
'Read combo switches to switch variable
' You could customize this in many ways
' SWITCH will equal 0 (no key) 
' or 1, 2, 3 for the 1, 2, or 3 keys
readsw:
switch=inc & 7 ' only 3 switches
switch=switch ^ 7 ' reverse sense (active low->active high)
if switch=0 then noread ' nothing
if switch<4 then readsw_ret ' correct switch 3
switch=3 ' top most switch
readsw_ret:
' now switch=0, 1, 2, or 3
pause 25 ' debounce
readloop:
if inc <> 15 then readloop ' wait for keys to go up
pause 25 ' debounce
debug ?switch
noread:
return 
' Reset RC timer
resettimer:
output rctrig
low rctrig ' discharge capacitor
pause 100 ' give it time
input rctrig
return

