' Merlin 1.0 - A game like Simon  
'(c) 1997 by AWC. All Rights Reserved.
' Uses a Basic Stamp I with 4 switches and LEDs on 
' P0-P3 and a speaker on P4.
' Play: Press P0 to start game, Merlin plays a note and 
' lights an LED.
' You must press the corresponding switch. Next, Merlin 
' adds a note and you must match him until you can play 16 ' notes in a row correctly.
' You get a raspberry if you lose and all the lights 
' come on if you win.

symbol temp=b0        ' temp storage
symbol maxstep=b1     ' tones in sequence
symbol i=b2           ' loop counter
symbol current=b3     ' current tone #
symbol cstep=b4       ' offset in byte of current tone
symbol ctone=b5       ' current tone (param to Sound)
symbol delay=40       ' general delay
symbol tlen=20        ' length of tone
symbol tone1=80       ' The four frequencies
symbol tone2=90
symbol tone3=100
symbol tone4=110

restart:              ' Wait for start button (1st button)
  w5=w5+1             ' randomize number
  w4=w4+2
  if pin0=1 then restart
restart0:
  if pin0=0 then start  ' wait for release of button
  goto restart
start:
maxstep=0               ' reset stuff
random w4               ' further randomize numbers
random w5

agn:
dirs=%11111             ' set outputs
pause 1500              ' let player "reset"
gosub display           ' display sequence
gosub readsw            ' wait for user input
maxstep=maxstep+1       ' he got it, so bump up and go
if maxstep<16 then agn  ' 16 is a winner
dirs=%11111
pins=0   ' all lamps on
sound 4,(100,delay,0,tlen,100,delay)
pins=15 ' all off
goto restart

' Display current sequence
display:
  for i=0 to maxstep
   pause delay     ' inter tone delay
   gosub geti      ' get current pattern
   lookup current,(14,13,11,7),temp  ' turn on one light
   pins=temp
   sound 4,(ctone,tlen)              ' make tone
   pins=15  ' all lamps off
  next i
  return

' This takes the current value of i and find
' the pattern (current) and the tone (ctone)
' would be easier with arrays
geti:
     cstep=i/4        ' which byte?
     temp=cstep*4     ' which two bits in the byte?
     temp=i-temp
     current=b8   ' load current with correct byte (b8-b11)
     if cstep=0 then getishift
     current=b9
     if cstep=1 then getishift
     current=b10
     if cstep=2 then getishift
     current=b11
 getishift:
     if temp=0 then getimask   ' if 1st bits, mask off
     current=current/4         ' otherwise shift right 2 places
     temp=temp-1               ' bump the count
     goto getishift            ' and try again
getimask:
     current=current&3         ' chop off last two bits
' convert to tone
     lookup current,(tone1,tone2,tone3,tone4),ctone       return

' Read user's input
readsw:
    dirs=0               ' change to inputs
    for i=0 to maxstep
      gosub geti	 ' get pattern
readloop:
      if pin0=0 then hit0   ' wait for a switch
      if pin1=0 then hit1
      if pin2=0 then hit2
      if pin3=0 then hit3     
      goto readloop
hit0:
    sound 4,(tone1,tlen)       ' make correct tone
    if current=0 then readswok ' go if correct
    goto readswbad             ' not correct
hit1:
    sound 4,(tone2,tlen)
    if current=1 then readswok
    goto readswbad
hit2:
   sound 4,(tone3,tlen)
   if current=2 then readswok
   goto readswbad
hit3:
   sound 4,(tone4,tlen)
   if current=3 then readswok
readswbad:
  sound 4,(33,1000)   ' lost!
  goto restart

' Success!
readswok:
    if pin0=0 or pin1=0 or pin2=0 or pin3=0  then readswok  ' wait for switch to open
  next i  ' keep going
' Got 'em all
  return  

